//Source file: H:\MIDDLEWARE\SRC\ALKINDI\BUSINESSSERVICES\STUBBEANIMPL\BOGUS.JAVA

package Alkindi.Services.StubBeanImpl;

import Alkindi.Data.*;

/* 
$Header: Bogus.java, 6, 2/13/01 5:55:53 PM, Schwartz, Joe$
$Log: 
 6    Alkindi Development1.5         2/13/01 5:55:53 PM   Schwartz, Joe  
      Changed to account for new Product ID int type.
 5    Alkindi Development1.4         12/28/00 1:07:21 PM  Schwartz, Joe   Added
      Version Control header info.
 4    Alkindi Development1.3         12/26/00 6:57:09 PM  Schwartz, Joe   
 3    Alkindi Development1.2         12/18/00 12:05:34 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 2    Alkindi Development1.1         11/6/00 7:05:58 PM   Schwartz, Joe   
 1    Alkindi Development1.0         10/30/00 7:51:06 PM  Schwartz, Joe   
$
$NoKeywords$
 */

/**
 */
public final class Bogus 
{
	
	public Bogus() 
	{
	}
	
	/**
	 * Returns a given number of bogus products as a ProductList.
	 * @roseuid 39FC582F007D
	 */
	public static ProductList getProductList(final int numDesired) 
	{
		ProductList pl = new ProductList(numDesired);
		for (int i = 0; i < numDesired; i++) {
			int r = (int)Math.round(Math.random()*150) + 1;
			pl.add(new Product(1, r));
		}
		return pl;
	}
	
	/**
	 * Returns a random number of bogus products in a list.
	 * @roseuid 39FC5FF301F4
	 */
	public static ProductList getProductList() 
	{
		int numToReturn = (int)Math.round(Math.random() * 9) + 1;
		return getProductList(numToReturn);
	}
	
	/**
	 * Returns the given number of bogus Ratings for the given SystemUser.
	 * @roseuid 39FC583D036B
	 */
	public static RatingList getRatingList(final SystemUser user, final int numDesired) 
	{
		RatingList rl = new RatingList();
		ProductList pl = getProductList(numDesired);
		int idx;
		for (idx = 0; idx < pl.size(); idx ++) {
		//	System.out.println("BRL: Adding product id=" + pl.get(idx).productID);
			int eval = (int)Math.round(Math.random() * 5) + 1;
     			Rating rec = new Rating (user, pl.get(idx), 5);
             		rl.add(rec);
     		}
		return rl;
	}
	
	/**
	 * Returns the given number of bogus Recommendations for the given SystemUser.
	 * @roseuid 39FC583600AB
	 */
	public static RecommendationList getRecList(final SystemUser user, final int numDesired) 
	{
		RecommendationList rl = new RecommendationList();
		ProductList pl = getProductList(numDesired);
		int idx;
		for (idx = 0; idx < pl.size(); idx ++) {
		//	System.out.println("BRL: Adding product id=" + pl.get(idx).productID);
			int rat = (int)Math.round(Math.random() * 5) + 1;
			int averat = (int)Math.round(Math.random() * 5) + 1;
     			Recommendation rec = new Recommendation(user, pl.get(idx), rat, averat);
             		rl.add(rec);
     		}
		return rl;
	}
	
	/**
	 * @roseuid 39FC582401F4
	 */
	public static SystemUser getUser() 
	{
		return new SystemUser((long)Math.round(Math.random() * 100) + 1);
	}
	
	/**
	 * Returns a randomly generated SystemUser.
	 * @roseuid 39FC5CC60280
	 */
	public static SystemUserList getUserList() 
	{
		//	Return a random number of bogus users.
		//	
		int numToReturn = (int)Math.round(Math.random() * 10) + 1;
		SystemUserList sul = new SystemUserList();
		for (int idx = numToReturn; --idx > -1; ) {
			sul.add(getUser());
		}
		return sul;
	}
}
